VERSION 5.00
Object = "{65E121D4-0C60-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCHRT20.OCX"
Begin VB.Form frmPIDStep 
   Caption         =   "2510-AT PID Temperature Control"
   ClientHeight    =   9045
   ClientLeft      =   3135
   ClientTop       =   1080
   ClientWidth     =   8985
   LinkTopic       =   "Form1"
   ScaleHeight     =   9045
   ScaleWidth      =   8985
   Begin VB.Frame fraChartChosen 
      Caption         =   "Temp vs Time Charts"
      Height          =   6855
      Left            =   120
      TabIndex        =   11
      Top             =   0
      Width           =   8535
      Begin VB.TextBox txtPIDChart 
         Appearance      =   0  'Flat
         BorderStyle     =   0  'None
         Height          =   615
         Index           =   2
         Left            =   6720
         Locked          =   -1  'True
         MultiLine       =   -1  'True
         TabIndex        =   20
         Top             =   3600
         Width           =   1695
      End
      Begin VB.TextBox txtPIDChart 
         Appearance      =   0  'Flat
         BorderStyle     =   0  'None
         Height          =   615
         Index           =   1
         Left            =   6720
         Locked          =   -1  'True
         MultiLine       =   -1  'True
         TabIndex        =   19
         Top             =   480
         Width           =   1695
      End
      Begin VB.OptionButton optChart 
         Caption         =   "Chart 2"
         Height          =   375
         Index           =   2
         Left            =   120
         TabIndex        =   13
         Top             =   4680
         Width           =   855
      End
      Begin VB.OptionButton optChart 
         Caption         =   "Chart 1"
         Height          =   375
         Index           =   1
         Left            =   120
         TabIndex        =   12
         Top             =   1440
         Width           =   855
      End
      Begin MSChart20Lib.MSChart MSChart2 
         Height          =   3255
         Left            =   1080
         OleObjectBlob   =   "frmPIDStep03.frx":0000
         TabIndex        =   14
         Top             =   3360
         Width           =   6735
      End
      Begin MSChart20Lib.MSChart MSChart1 
         Height          =   3255
         Left            =   1080
         OleObjectBlob   =   "frmPIDStep03.frx":2356
         TabIndex        =   15
         Top             =   240
         Width           =   6735
      End
      Begin VB.Label Label1 
         Caption         =   "Choose Chart"
         Height          =   375
         Left            =   120
         TabIndex        =   16
         Top             =   840
         Width           =   735
      End
   End
   Begin VB.Frame fraTemp 
      Caption         =   "Temperature Setpoint"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1335
      Left            =   120
      TabIndex        =   8
      Top             =   6960
      Width           =   3735
      Begin VB.CheckBox chkStop 
         Caption         =   "Stop Charting"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   2040
         TabIndex        =   18
         Top             =   960
         Width           =   1575
      End
      Begin VB.CommandButton cmdGoToStartTemp 
         Caption         =   "Go To Setpoint"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   615
         Left            =   2280
         TabIndex        =   10
         Top             =   240
         Width           =   1212
      End
      Begin VB.TextBox txtStartTemp 
         Alignment       =   2  'Center
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   12
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   360
         Left            =   1320
         TabIndex        =   1
         Text            =   "20"
         Top             =   480
         Width           =   735
      End
      Begin VB.Label Label7 
         Caption         =   "Setpoint (C)"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   120
         TabIndex        =   9
         Top             =   480
         Width           =   1095
      End
   End
   Begin VB.Frame fraActive 
      Caption         =   "Active 2510 PID Coefficients "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1335
      Left            =   4080
      TabIndex        =   0
      Top             =   6960
      Width           =   4575
      Begin VB.CommandButton cmdChangePID 
         Caption         =   "Change PIDs"
         Height          =   495
         Left            =   3240
         TabIndex        =   17
         Top             =   600
         Width           =   1215
      End
      Begin VB.TextBox txtKp 
         Alignment       =   2  'Center
         BorderStyle     =   0  'None
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0.000"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1033
            SubFormatType   =   1
         EndProperty
         Height          =   288
         Left            =   240
         Locked          =   -1  'True
         TabIndex        =   4
         TabStop         =   0   'False
         Top             =   720
         Width           =   852
      End
      Begin VB.TextBox txtKi 
         Alignment       =   2  'Center
         BorderStyle     =   0  'None
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0.000"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1033
            SubFormatType   =   1
         EndProperty
         Height          =   288
         Left            =   1200
         Locked          =   -1  'True
         TabIndex        =   3
         TabStop         =   0   'False
         Top             =   720
         Width           =   852
      End
      Begin VB.TextBox txtKd 
         Alignment       =   2  'Center
         BorderStyle     =   0  'None
         BeginProperty DataFormat 
            Type            =   1
            Format          =   "0.000"
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1033
            SubFormatType   =   1
         EndProperty
         Height          =   288
         Left            =   2160
         Locked          =   -1  'True
         TabIndex        =   2
         TabStop         =   0   'False
         Top             =   720
         Width           =   852
      End
      Begin VB.Label lblP 
         Caption         =   "Kp"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   480
         TabIndex        =   7
         Top             =   360
         Width           =   255
      End
      Begin VB.Label lblI 
         Caption         =   "Ki"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   1440
         TabIndex        =   6
         Top             =   360
         Width           =   255
      End
      Begin VB.Label lblD 
         Caption         =   "Kd"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   9.75
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   2400
         TabIndex        =   5
         Top             =   360
         Width           =   255
      End
   End
   Begin VB.Image Image3 
      Appearance      =   0  'Flat
      Height          =   585
      Left            =   6240
      Picture         =   "frmPIDStep03.frx":46AC
      Stretch         =   -1  'True
      Top             =   8400
      Width           =   2700
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuQuit 
         Caption         =   "&Quit"
      End
   End
   Begin VB.Menu mnuSettings 
      Caption         =   "&Settings"
      Begin VB.Menu mnuGPIBSettings 
         Caption         =   "&GPIB Settings"
      End
      Begin VB.Menu mnuAdvanced 
         Caption         =   "&Advanced Settings"
      End
   End
   Begin VB.Menu menuHelp 
      Caption         =   "Help"
      Begin VB.Menu submenuAbout 
         Caption         =   "About"
      End
   End
End
Attribute VB_Name = "frmPIDStep"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'PID Step Form
'This form does a PID-controlled temperature step on the 2510 or 2510-AT
'and displays the results in one (of two, user-chosen) chart
'NOTE:  Max length (time) of graphed temp is dependent on # of points in
'chart, which has a huge effect on time required to maintain the chart (initialize, etc)
'so graph length is a compromise between long times and chart overhead
'(if desired, sample temp from 2510 (read?) less often)

'definitions

Public SaveData As Boolean
'Public strsystime As String
'Public strsysdata As String
Public sngnumpts As Single
Public sngSetpoint As Single                'Temperature setpoint
Public intChosenChart As Integer            'Saves chosen chart value (1 or 2)

Private Sub cmdChangePID_Click()
'bring up PID form

frmPIDCoeff.Show

End Sub

Private Sub cmdGoToStartTemp_Click()
'Configure 2510, turn output on, go to temp and chart temp vs time (relative time from 2510)

Dim poll As Integer                 'status returned from serial poll
Dim intSRQ As Integer               'SQR result
Dim strsystime As String            '2510 system time
Dim strdata As String               'Reading from 2510
Dim arraystrdata() As String        'Parsed reading from 2510
Dim StartTime As Single             'system time variable
Dim sngPause As Single              'Time between temp readings
Dim i As Integer

sngPause = 1.5                      'Take 1 reading/sec, faster (>700 MHz) computers can probably support a higher rate

chkStop.value = False               'uncheck stop taking data box

'Clear chosen chart
Select Case intChosenChart

    Case 1  'Chart 1 is 'active'
    Prep_Chart1                     'Clear chart 1
    
    Case 2  'Chart 2 is 'active'
    Prep_Chart2                     'Clear chart 2

End Select

ChartPIDValues (intChosenChart)     'Update current 2510 PID values to 'active' chart

'If chkSaveData = True Then                      'Save Data to file?
'    Open txtDataFileName.Text For Output As #1
'    blnfileopen = True
'End If
'
'Print #1, "Temp,Volt,Curr,Time"
'
''set up 2510 data format
Call SendKI(intKI2510, "form:data asc")                         'Return data in ASCii format
Call SendKI(intKI2510, "form:elem temp,volt,curr,time")         'Return these data elements, in this order (cannot specify order)
Call SendKI(intKI2510, "sour:func temp")                        'Use temperature control mode


Call Config2510                                 'Set temp transducer and TEC protection parameters

'If optStopData(0) Then      'If Stop on SRQ chosen, then configure
'    'Configure SRQ to flag when Setpoint tolerance reached (see Config2510 for tolerance window settings)
'    poll = PollKI(intKI2510)            'clear SRQ status byte (& clears SRQ annunciator on front panel)
'    If SendKI(intKI2510, "stat:meas:enab 4096") Then Exit Sub       'Enable Setpoint Tolerance event for SRQ
'    If SendKI(intKI2510, "*sre 1") Then Exit Sub                    'Service Request Enable on Measurement Summary Bit for Setpoint Tol. SRQ
'    If SendKI(intKI2510, "*cls") Then Exit Sub                      'clear status registers, must be done to get correct SRQ condition
'End If

''Format data to be returned with the Read command
''If SendKI(intKI2510, "form:elem temp") Then Exit Sub            'Return temp data
'
''Set setpoint tolerance & window, which determines
''when the 2510 reports that the setpoint has been reached
'If SendKI(intKI2510, "sour:stol:perc " & sngTolerance) Then Exit Sub    'Set setpoint tolerance %
'If SendKI(intKI2510, "sour:stol:coun " & intWindow) Then Exit Sub       'Set setpoint window
'
''Mask measurement summary bit to raise SRQ when tolerance & window conditions are met
'If SendKI(intKI2510, "stat:meas:enab 4096") Then Exit Sub       'Mask bit 12 of the measurement event register
'If SendKI(intKI2510, "*sre 1") Then Exit Sub                    'Mask service request enable register to generate SRQ on setpoint reached
'If SendKI(intKI2510, "*cls") Then Exit Sub                      'clear status register
'
'set start temp in 2510/2510-AT
sngSetpoint = Val(txtStartTemp.Text)                    'Capture setpoint, convert to single
txtStartTemp.Text = sngSetpoint                         'Update text box
Call SendKI(intKI2510, "sour:temp " & sngSetpoint)
'Call SendKI(intKI2510, "sour:temp " & txtStartTemp.Text)


''turn on unit (control temp)
Call SendKI(intKI2510, "outp:stat on")
'numpts = 0

'Reset instrument clock, then take reading (helps ensure clock is actually reset)
Call SendKI(intKI2510, "syst:time:res")
Call SendKI(intKI2510, ":syst:time?")
strsystime = QueryKI(intKI2510)

''gray out button
cmdGoToStartTemp.Enabled = False

'Take reading, sometimes first time sample is bad
Call SendKI(intKI2510, ":read?")
strdata = QueryKI(intKI2510)             'Single reading of temp & time (in that order)

For i = 1 To maxNumPoints

    StartTime = Timer               'Grab present time stamp
    
    strdata = Space$(80)                         'Clear data str
    
    'Take reading, sometimes first time sample is bad
    Call SendKI(intKI2510, ":read?")
    strdata = QueryKI(intKI2510)             'Single reading of temp & time (in that order)
    
    arraystrdata = Split(strdata, ",")        'Split the data into 2 pieces, based on comma delimeter
    
    'Grab data for chart, ignore volt & curr
    arraydata(1, i) = CSng(arraystrdata(3))        'Copy time value, mult by 10 to make graphing work
    arraydata(2, i) = CSng(arraystrdata(0))         'Copy temp value
    
    Call Plot_Temp(i)               'Plot data point on chosen chart
    frmTestData.Text1.Text = frmTestData.Text1.Text & arraydata(1, i) & ", " & arraydata(2, i) & vbCrLf
    
    
    'Pause between readings
'    StartTime = Timer               'Grab present time stamp
    While (Timer - StartTime) < sngPause        'Wait until time for next temperature reading
    'Do nothing
    DoEvents
    Wend
    
'    If chkStop.value Then
'    If chkStop.value Or (SrqKI And 1) Then          'If Stop Now is chosen or setpoint tolerance reached, stop taking & graphing data
    If chkStop.value Then                   'If Stop Charting is checked, then stop
'        frmTestData.Show                    'Display Test Data (troubleshooting)
        cmdGoToStartTemp.Enabled = True     'Enable button
        poll = PollKI(intKI2510)            'clear SRQ status byte (& clears SRQ annunciator on front panel)
        Exit Sub
    End If

Next i

'Do
'    DoEvents        '2510 will issue an srq once setpoint is reached (based on sngTolerance and intWindow)
'Loop Until (SrqKI And 1)
'
'poll = PollKI(intKI2510)           'clear SRQ status byte (& clears SRQ annunciator on front panel)


''Enable button
'cmdGoToStartTemp.Enabled = True

End Sub

Private Sub cmdStartTakingData_Click()

'gray out button
cmdStartTakingData.Enabled = False
cmdGoToStartTemp.Enabled = False

'turn on exit button
cmdStopTakingData.Enabled = True

'reset 2510 time stamp
Call SendKI(intKI2510, "syst:time:res")

'get good time stamp
Call SendKI(intKI2510, ":syst:time?")           'Query 2510 system time
strsystime = QueryKI(intKI2510)                 'Retrieve system time from instrument
Call SendKI(intKI2510, ":syst:time?")
strsystime = QueryKI(intKI2510)

'set stop temp in 2510-AT
Call SendKI(intKI2510, "sour:temp " & txtStopTemp.Text)

'start saving data
SaveData = True

'reset 2510 time stamp again
Call SendKI(intKI2510, "syst:time:res")
Call SendKI(intKI2510, ":syst:time?")
strsystime = QueryKI(intKI2510)

'get first data set
strsysdata = Space$(80)
Call SendKI(intKI2510, ":read?")
strsysdata = QueryKI(intKI2510)

'save it
Print #1, strsysdata

'Enter data save loop
getdat:
numpts = numpts + 1
txtNumPoints.Text = Format(numpts, "######")

'check for other system events
DoEvents

'get next data set
strsysdata = Space$(80)
Call SendKI(intKI2510, ":read?")
strsysdata = QueryKI(intKI2510)

Print #1, strsysdata
If SaveData = True Then GoTo getdat

'all done with data taking, clean up and exit
Close #1
fileopen = False

'turn on buttons

cmdStartTakingData.Enabled = True
cmdGoToStartTemp.Enabled = True


End Sub

Private Sub cmdStopTakingData_Click()

'stop taking data
SaveData = False
cmdStopTakingData.Enabled = False

End Sub
Public Sub SaveDatatoFile()
'This routine will save data to disk in CSV (comma separated value) format
'This includes the presently used PID coefficients

'Declare local variable
Dim i As Integer
Dim txtIDN As String
Dim strpresKp As String
Dim strpresKi As String
Dim strpresKd As String
Dim strVlim As String
Dim strIlim As String
Dim strHiTemp As String
Dim strLoTemp As String
Dim strTempTrans As String
Dim strUnits As String

' Set CancelError is True
CommonDialog1.CancelError = True
On Error GoTo ErrHandler
' Set flags
CommonDialog1.Flags = cdlOFNHideReadOnly + cdlOFNOverwritePrompt    'Raise prompt if file already exists or is currently open
' Set filters
CommonDialog1.Filter = "CSV Files (*.CSV)|*.csv"
' Specify default filter
CommonDialog1.FilterIndex = 1
' Display the Open dialog box
CommonDialog1.ShowSave

Call SendKI(intKI2510, "*IDN?")                     'Query instrument IDN string
txtIDN = QueryKI(intKI2510)                         'Retrieve data

'Get presently used (i.e., current) PID coefficients
Call SendKI(intKI2510, "sour:temp:lcon:gain?")      'get present Kp
strpresKp = QueryKI(intKI2510)                      'Retrieve data

Call SendKI(intKI2510, "sour:temp:lcon:int?")       'get present Ki
strpresKi = QueryKI(intKI2510)

Call SendKI(intKI2510, "sour:temp:lcon:der?")       'get present Kd
strpresKd = QueryKI(intKI2510)

Call SendKI(intKI2510, "sour:temp:prot:high?")       'Query high temp limit
strHiTemp = QueryKI(intKI2510)                      'Retrieve data

Call SendKI(intKI2510, "sour:temp:prot:low?")       'Query high temp limit
strLoTemp = QueryKI(intKI2510)                      'Retrieve data

Call SendKI(intKI2510, "sens:res:tran?")            'Query temperature transducer type (RTD or THERmistor)
strTemptran = QueryKI(intKI2510)

Call SendKI(intKI2510, "sens:curr:prot?")            'Query Current limit
strIlim = QueryKI(intKI2510)

Call SendKI(intKI2510, "sour:volt:prot?")            'Query Voltage limit
strVlim = QueryKI(intKI2510)

Call SendKI(intKI2510, ":unit:temp?")                'Query Temp units
strUnits = QueryKI(intKI2510)                       'Retrieve data

Open CommonDialog1.filename For Output As #1
Print #1, Date, ",", Time
'Print #1, txtComments
Print #1, "2510 TEC Protection Settings:"
Print #1, "Current Limit (A) = ,", strIlim, ",Voltage Limit (V) = ,", strVlim
Print #1, "High Temperature Protection = ,", strHiTemp, ",Low Temperature Protection = ,", strLoTemp
Print #1, "2510 Temperature Control Settings:"
Print #1, "Temperature Transducer = ,", strTemptran
Print #1, "Temperature Units = ,", strUnits
Print #1, "P = ,", strpresKp, ",I = ,", strpresKi, ",D = ,", strpresKd

'Below code not yet finished!
'    For i = 1 To intSteps
'        strdata = dblArray(intLDCurr, i) & ","
'        strdata = strdata & dblArray(intLDVolt, i) & ","
'        strdata = strdata & dblArray(intDet1Curr, i) & ","
'        strdata = strdata & dblArray(intDet2Curr, i) & ","
'        strdata = strdata & dblArray(int2ndDeriv, i) & ","
'        strdata = strdata & dblArray(int1stDeriv, i) & ","
'        Print #1, strdata
'    Next i


Close #1                'Close data file

If CommonDialog1.filename <> "" Then                'If filename not blank, then store name and set blnSaveFileLoaded to true
        strSaveFileName = CommonDialog1.filename
        blnSaveFileLoaded = True
    End If
  
  Exit Sub

ErrHandler:
    'User pressed the Cancel button, file already exists, etc
    'add error handling routine here

blnSaveFileLoaded = False

Select Case Err.Number

Case 75
        MsgBox "Cannot open specified output file", vbExclamation

Case 70
        MsgBox "Permission Denied.  File is already open.  Choose another file name.", vbExclamation, "File Already Exists"
        Call SaveDatatoFile

Case cdlCancel
    Exit Sub
   
Case Else
    MsgBox Err.Description, , "Error Description"
    MsgBox Err.Number

End Select

End Sub

Private Sub Form_Activate()

'Form_Load               'Make sure PID stuff is appropriately displayed for 2510 or 2510-AT

End Sub

Private Sub Form_Initialize()
'Set up form, controls, variables

'Chose default temp chart and add PID values to associated textbox
optChart(1).value = True            'Make chart 1 the default

'add tool tip texts
fraActive.ToolTipText = "These are the PID coefficients that will be used when ""Go To Setpoint"" is pressed."
lblP.ToolTipText = "Proportional gain term, click for more info."
lblI.ToolTipText = "Integral gain term, click for more info."
lblD.ToolTipText = "Derivative gain term, click for more info."
optChart(1).ToolTipText = "Click here to use this chart."
optChart(2).ToolTipText = "Click here to use this chart."

End Sub

Private Sub Form_Load()
Dim OK2510Present As Boolean

'Specify title for instrument: 2510 or 2510-AT
If intModel = int2510 Then
    frmPIDStep.Caption = "Keithley 2510 PID Temperature Control"
    ElseIf intModel = int2510AT Then
    frmPIDStep.Caption = "Keithley 2510-AT PID Temperature Control"
End If

GetPresentPID                       'Update Active PIDs displayed

'Initialize Charts
Prep_Chart1
Prep_Chart2


'no save data
SaveData = False
fileopen = False



End Sub

Private Sub optChart_Click(Index As Integer)
'This procedure copies the current (active) PID values
'into the PID window in the upper right of the chosen chart

'Call ChartPIDValues(Index)

'This prodecure just saves the chosen chart #

intChosenChart = Index

End Sub

Private Sub submenuAbout_Click()

frmAbout.Show

End Sub
Private Sub mnuQuit_Click()
'Quit program

Unload frmAutotune

End Sub
Private Sub mnuGPIBsettings_Click()
'Bring up GPIB settings form

frmGPIBSettings.txt2510GPIB.Text = intKI2510                     '(re-)set GPIB address
frmGPIBSettings.Show vbModal

End Sub
Private Sub mnuAdvanced_Click()
'Show form

frmAdvSettings.fraSetpoint.Visible = True
frmAdvSettings.Show

End Sub

Private Sub lblD_Click()
'Display brief explanation of Derivative term

Call Deriv_Info

End Sub

Private Sub lblI_Click()
'Display brief explanation of Integral term

Call Integral_Info

End Sub

Private Sub lblP_Click()
'Display brief explanation of Proportional term

Call Gain_Info

End Sub


Public Sub Plot_Temp(n As Integer)
'This procedure will plot the temperature readings from the 2510
'vs time (2510 time, which is relative, zero'd when user presses
'"go to temp"

If optChart(1).value Then        'Chart 1 chosen
    MSChart1.Visible = False
    With MSChart1.DataGrid
        .SetData n, 1, arraydata(1, n), False       'Time Data
        .SetData n, 2, arraydata(2, n), False       'Temp data
        .SetData n, 3, arraydata(1, n), False       'Time data
        .SetData n, 4, sngSetpoint, False           'Setpoint
    End With
    MSChart1.Visible = True
    Else
    With MSChart2.DataGrid
        .SetData n, 1, arraydata(1, n), False       'Time Data
        .SetData n, 2, arraydata(2, n), False       'Temp data
        .SetData n, 3, arraydata(1, n), False       'Time data
        .SetData n, 4, sngSetpoint, False           'Setpoint
    End With
End If


End Sub

Public Sub ChartPIDValues(Index As Integer)
'Put PID values into chosen temp chart

txtPIDChart(Index).Text = "P = " & txtKp.Text & vbCrLf & _
                    "I = " & txtKi.Text & vbCrLf & _
                    "D = " & txtKd.Text & vbCrLf


End Sub
